getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(R.matlab)
library(proxy)
library(abind)
library(scatterplot3d)
library(Matrix)
library(purrr)
library(plyr)
library(multiway)

## Data
load("s3-ini-setting.RData")
load("s3.pre.to.list.RData")

## Model: f(x) = B*U1*U2*x; B: 3*3*2, U1/2: 3*3, x:3*2
dim.b = c(3,3,3); dim.u1 = c(4,3); dim.u2 = c(5,3); dim.x = c(2,3)
dim.f = c(4,5,2); dim.s = dim.f

dim.h = prod(dim.f); dim.mode = length(dim.f)
d = 3; lower.x = rep(0,d); upper.x = rep(1,d)

B <- e3.ini.set$B
U_mat <- e3.ini.set$U_mat
V <- e3.ini.set$V

true.model <- function(x){
  X1 = sin(5*x); X2 = cos(x)
  X = matrix(cbind(X1,X2),dim.x)
  return(array(ttm(V, X, m = 3)@data,dim.f))
}
h <- function(x) sum(true.model(x))

x.star = directL(function(x0) -h(x0),lower.x,upper.x,control=list(xtol_rel=1e-8, maxeval=1000))$par
x.star = t(as.matrix(x.star))
t.star = true.model(x.star); h.star = h(x.star)

## Kernel
norm0 <- function(x1,x2) as.matrix(dist(x1,x2,method = "Euclidean"))
norm1 <- function(x1,x2){
  nor = list()
  for(i in 1:d){
    nor[[i]] = norm0(x1[,i],x2[,i])}
  return(nor)
} 

mat0 <- function(x) matern(x, phi=1, kappa=5/2)
gau0 <- function(x) exp(-x^2)
exp0 <- function(x) exp(-abs(x))

ker.sele <- function(x1,x2,theta,ker){
  dis.x = norm1(x1,x2)
  theta0 = rep(list(theta),d)
  dis = Map(function(x0,th) x0/th,dis.x,theta0)
  R0 = Map(function(x0) ker(x0),dis)
  R = Reduce("*", R0)
  return(R)
}

################################################################################
#### GP ########################################################################
################################################################################

################################################################################
## Our proposed method: TOGP
vec.lab = list()
for(om.lab in 1:dim.mode){
  vec.lab[[om.lab]] = dim.s[om.lab]*(dim.s[om.lab]-1)/2
}
for(th.lab in (dim.mode+1):(2*dim.mode)){
  vec.lab[[th.lab]] = dim.s[th.lab-dim.mode]#*d
}
vec.lab[[2*dim.mode+1]] = vec.lab[[2*dim.mode+2]] = 1

group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.to = length(group.lab)

lower.th = c(unlist(Map(rep, c(rep(1e-3,dim.mode),rep(1e-3,dim.mode),1e-2,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(pi,pi,pi,10,10,10,10,1e-2), unlist(vec.lab))))

sig.to <- function(t0, omega){
  O = matrix(0,t0,t0)
  O[lower.tri(O, diag = FALSE)] <- omega
  
  L <- matrix(0, t0, t0); L[lower.tri(L, diag = TRUE)] = 1
  sin_prod <- unlist(apply(as.matrix(O[-1,]),1,function(row) cumprod(sin(row[which(row!=0)]))))
  L[-1,-1][lower.tri(L[-1,-1],diag=TRUE)] <- sin_prod
  L[-1,-1][lower.tri(L[-1,-1],diag=FALSE)] <- cos(O[-1,-1][lower.tri(O[-1,-1],diag=FALSE)])*
    L[-1,-1][lower.tri(L[-1,-1],diag=FALSE)]
  L[2:t0, 1] = cos(O[c(2:t0),1])
  return(L)
}


k.mode.to <- function(x1,x2,t0,omega,theta){
  x1 = matrix(x1,length(x1)/d,d); x2 = matrix(x2,length(x2)/d,d)
  n.s1 = nrow(x1); n.s2 = nrow(x2)
  theta = matrix(theta,t0,1)
  k_x = matrix(apply(theta,1,function(psi) ker.sele(x1,x2,psi,mat0)),n.s1*n.s2,t0)
  
  result = apply(k_x,1,function(x) sig.to(t0,omega)%*%diag(x)%*%t(sig.to(t0,omega)))
  result1 = array(c(result), dim=c(t0,t0,n.s1*n.s2))
  result2 <- lapply(seq_len(n.s1*n.s2), function(k) result1[,,k])
  dim(result2) <- c(n.s1,n.s2)
  return(result2)
}
# k.mode.to(x,x,t0,omega,theta)[1,2][[1]]-k.mode.to(x[3,],x[5,],t0,omega,theta)[1,1][[1]]


ker.to <- function(x1,x2,the){
  x1 = matrix(x1,length(x1)/d,d); x2 = matrix(x2,length(x2)/d,d)
  n.s1 = nrow(x1); n.s2 = nrow(x2)
  the0 = split(the, group.lab)
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],the0[[i]],the0[[i+dim.mode]])
  
  K = lapply(Omega,function(the) t(k.mode.to(x1,x2,the[[1]],the[[2]],the[[3]])))
  
  K.vec = mapply(function(x, y, z) {
    kronecker(x, kronecker(y, z))
  }, K[[1]], K[[2]], K[[3]], SIMPLIFY = FALSE)
  dim(K.vec) <- c(n.s1, n.s2)
  
  K.rows = lapply(1:n.s1, function(i) {
    do.call(cbind, K.vec[(i-1)*n.s2 + 1:n.s2])
  })
  K.re = do.call(rbind, K.rows)
  return(K.re) 
}
# ker.to(x,x,runif(dim.hyper.to))


der.l.th_om <- function(x1,x2,t0,omega,theta){
  ## der.l.th_lij
  x1 = matrix(x1,length(x1)/d,d); x2 = matrix(x2,length(x2)/d,d)
  n.s1 = nrow(x1); n.s2 = nrow(x2)
  theta0 = matrix(theta,t0,1)
  
  k_x = matrix(apply(theta0,1,function(psi) ker.sele(x1,x2,psi,mat0)),n.s1*n.s2,t0)
  A_l = sig.to(t0,omega)
  
  der.kx_l.th = as.matrix(apply(theta0,1,function(theta) jacobian(function(th) ker.sele(x1,x2,th,mat0), theta)))
  der.k_l.th0 = lapply(1:t0, function(l) 
    array(sapply(1:(n.s1*n.s2), function(i) der.kx_l.th[i,l]*A_l[,l]%*%t(A_l[,l])), c(t0,t0,(n.s1*n.s2))))
  
  der.k_l.th = lapply(der.k_l.th0, function(arr) {
    slices <- lapply(seq_len(dim(arr)[3]), function(i) arr[,,i])
    dim(slices) = c(n.s1, n.s2)
    return(slices)
  })
  
  der.a_l.phi0 = jacobian(function(om) sig.to(t0,om), omega)
  der.a_l.phi = lapply(seq_len(t0*(t0-1)/2), function(i) matrix(der.a_l.phi0[, i],t0,t0))
  
  der.k_l.phi0 = lapply(1:(t0*(t0-1)/2), function(l) 
    array(sapply(1:(n.s1*n.s2),function(i) der.a_l.phi[[l]]%*%diag(k_x[i,])%*%t(A_l)+A_l%*%diag(k_x[i,])%*%t(der.a_l.phi[[l]])), c(t0,t0,(n.s1*n.s2))))
  
  der.k_l.phi = lapply(der.k_l.phi0, function(arr) {
    slices <- lapply(seq_len(dim(arr)[3]), function(i) arr[,,i])
    dim(slices) = c(n.s1, n.s2)
    return(slices)
  })
  
  return(list(der.k_l.th=der.k_l.th, der.k_l.phi=der.k_l.phi))
}
# der.l.th_om(x,x,4,runif(6),runif(4))


der.l <- function(x,y,n,the){
  the0 = split(the[1:dim.hyper.to], group.lab)
  
  ome = list(); for(i in 1:dim.mode) ome[[i]] = the0[[i]]
  th = list(); for(i in 1:dim.mode) th[[i]] = the0[[i+dim.mode]]
  sig2 = the0[[2*dim.mode+1]]; tau2 = the0[[2*dim.mode+2]]
  
  k.ini = ker.to(x,x,the[1:dim.hyper.to])
  k.y = sig2*k.ini + tau2*diag(n*dim.h)
  sol.k.y = solve(k.y)
  al.k = sol.k.y%*%c(y)
  
  der.l.sig2 = tr(sol.k.y%*%k.ini)-t(al.k)%*%k.ini%*%al.k
  der.l.tau2 = tr(sol.k.y)-t(al.k)%*%al.k
  
  der.l.k <- function(a) tr(sig2*sol.k.y%*%a)-
    t(al.k)%*%a%*%al.k
  
  x = matrix(x,length(x)/d,d); n.s1 = n.s2 = nrow(x)
  
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],ome[[i]],th[[i]])
  K = lapply(Omega,function(the) k.mode.to(x,x,the[[1]],the[[2]],the[[3]]))
  
  der.l = lapply(Omega,function(the) der.l.th_om(x,x,the[[1]],the[[2]],the[[3]]))
  der.l.th = map(der.l, 1); der.l.phi = map(der.l, 2)
  
  K.list.func <- function(a,b,c) mapply(function(x, y, z) {
    kronecker(x, kronecker(y,z))
  }, a, b, c, SIMPLIFY = FALSE)
  
  der.like.th = der.like.phi = list()
  for(l in 1:dim.mode){
    if (l==1){
      list1 = 1; list2 = K.list.func(1,K[[2]],K[[3]]) 
      der.K.th = lapply(der.l.th[[1]], function(b) {
        re1 = K.list.func(list1,b,list2); dim(re1) = c(n.s1,n.s2)
        re1.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re1[(i-1)*n.s2 + 1:n.s2])
        })
        re1.re = do.call(rbind, re1.rows); return(re1.re)
      })
      der.K.phi = lapply(der.l.phi[[1]], function(b) {
        re2 = K.list.func(list1,b,list2); dim(re2) = c(n.s1,n.s2)
        re2.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re2[(i-1)*n.s2 + 1:n.s2])
        })
        re2.re = do.call(rbind, re2.rows); return(re2.re)
      })
      der.like.th[[1]] = lapply(der.K.th, der.l.k)
      der.like.phi[[1]] = lapply(der.K.phi, der.l.k)
    }
    if (l==2){
      list1 = K[[1]]; list2 = K[[3]]
      der.K.th = lapply(der.l.th[[2]], function(b) {
        re1 = K.list.func(list1,b,list2); dim(re1) = c(n.s1,n.s2)
        re1.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re1[(i-1)*n.s2 + 1:n.s2])
        })
        re1.re = do.call(rbind, re1.rows); return(re1.re)
      })
      der.K.phi = lapply(der.l.phi[[2]], function(b) {
        re2 = K.list.func(list1,b,list2); dim(re2) = c(n.s1,n.s2)
        re2.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re2[(i-1)*n.s2 + 1:n.s2])
        })
        re2.re = do.call(rbind, re2.rows); return(re2.re)
      })
      der.like.th[[2]] = lapply(der.K.th, der.l.k)
      der.like.phi[[2]] = lapply(der.K.phi, der.l.k)
    }
    if (l==3){
      list1 = K.list.func(K[[1]],K[[2]],1) ; list2 = 1
      der.K.th = lapply(der.l.th[[3]], function(b) {
        re1 = K.list.func(list1,b,list2); dim(re1) = c(n.s1,n.s2)
        re1.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re1[(i-1)*n.s2 + 1:n.s2])
        })
        re1.re = do.call(rbind, re1.rows); return(re1.re)
      })
      der.K.phi = lapply(der.l.phi[[3]], function(b) {
        re2 = K.list.func(list1,b,list2); dim(re2) = c(n.s1,n.s2)
        re2.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re2[(i-1)*n.s2 + 1:n.s2])
        })
        re2.re = do.call(rbind, re2.rows); return(re2.re)
      })
      der.like.th[[3]] = lapply(der.K.th, der.l.k)
      der.like.phi[[3]] = lapply(der.K.phi, der.l.k)
    }
  }
  
  result = list(der.like.th=der.like.th, der.like.phi=der.like.phi, der.l.sig2=der.l.sig2, der.l.tau2=der.l.tau2)
  return(result)
}
# der.l(x,y.0,n,runif(dim.hyper.to))


likeli.to <- function(x,y,n,the){
  the0 = split(the, group.lab)
  k.ini = ker.to(x,x,the)
  sig2 = the0[[2*dim.mode+1]]; tau2 = the0[[2*dim.mode+2]]
  
  log.likeli = determinant(sig2*k.ini+tau2*diag(n*dim.h),logarithm=TRUE)$modulus+
    t(c(y))%*%solve(sig2*k.ini+tau2*diag(n*dim.h))%*%c(y)
  return(list(like=log.likeli, the0=the0))
}
# likeli.to(x,y,k.ind,n,runif(dim.hyper.to))


togp.hat <- function(x.new,x,y,n,n.test,hy){
  x.new = matrix(x.new,n.test,d)
  sig2 = hy[[2*dim.mode+1]]; tau2 = hy[[2*dim.mode+2]]
  
  k.ini = ker.to(x,x,unlist(hy))
  k.to.1 = ker.to(x.new,x,unlist(hy))
  k.to.0 = ker.to(x.new,x.new,unlist(hy))
  
  k.oth = k.to.1%*%solve(k.ini+tau2/sig2*diag(n*dim.h))
  
  f.hat = k.oth%*%c(y)
  var.hat = sig2*(k.to.0-k.oth%*%t(k.to.1))
  
  result = list(mean=f.hat, cov=var.hat)
  return(result)
}
# hy=split(runif(dim.hyper.to), group.lab)


################################################################################
################################################################################
##GP Pre########################################################################
################################################################################
################################################################################

################################################################################
## Our proposed method: SE-TOBO
n = 5*d; m  = 10*d; lambda = 0.1; J.for = 10

like.re.to = hyper.to = lapply(1:J.for, function(x) list())
x0.to = y0.to = list(); fhat = lapply(1:J.for, function(x) list())
togp.bo = h.to = list()
mse.x.to = mae.y.to = list()
regret.to = ins.regret.to = cum.regret.to = list()

for(j.for.to in 1:J.for){
  x = e3.ini.set$x
  f = e3.ini.set$f
  y = e3.ini.set$y.for[[j.for.to]]
  
  ## Setting
  ######################################## BO ####################################
  hyper.to.old = directL(function(the) likeli.to(x,y,n,the)$like,lower.th,upper.th,control=list(xtol_rel=1e-8, maxeval=1000))$par
  hyper.to.new = optim(par = hyper.to.old,
                       fn = function(the) likeli.to(x,y,n,the)$like,
                       gr = function(the) unlist(der.l(x,y,n,the)),
                       method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
  like.re.to[[j.for.to]][[1]] = likeli.to(x,y,n,hyper.to.new)
  hyper.to[[j.for.to]][[1]] = like.re.to[[j.for.to]][[1]]$the0
  
  pre.train = togp.hat(x,x,y,n,n,hyper.to[[j.for.to]][[1]])
  f.hat.train = pre.train$mean; var.hat.train = pre.train$cov
  
  x0.to[[j.for.to]] = x; y0.to[[j.for.to]] = y; n.to = n
  
  y.new.to = y[,,,which.max(apply(y,dim.mode+1,sum))]
  x.new.to = t(as.matrix(x[which.max(apply(y,dim.mode+1,sum)),]))
  
  hyper.to.ucb = unlist(hyper.to[[j.for.to]][[1]]); delta.to = 0.05
  fhat[[j.for.to]][[1]] = togp.hat(x.new.to,x0.to[[j.for.to]],y0.to[[j.for.to]],
                                   n.to,n.test=1,hyper.to[[j.for.to]][[1]])
  
  for(i.to in 1:m){
    x.new.to = t(t(randomLHS(1,d))*(upper.x-lower.x) + lower.x)
    
    fhat[[j.for.to]][[i.to+1]] = togp.hat(x.new.to,x0.to[[j.for.to]],y0.to[[j.for.to]],
                                          n.to,n.test=1,hyper.to[[j.for.to]][[i.to]])
    y.new.to = true.model(x.new.to)+array(rnorm(dim.h,mean=0,sd=lambda),dim.f)
    
    x0.to[[j.for.to]] = rbind(x0.to[[j.for.to]], x.new.to)
    y0.to[[j.for.to]] = abind(y0.to[[j.for.to]], y.new.to, along = dim.mode+1)
    n.to = n+i.to
    
    if(i.to %% 5 == 0){
      hyper.to.ucb = optim(par = unlist(hyper.to[[j.for.to]][[i.to]]),
                           fn = function(the) likeli.to(x0.to[[j.for.to]],y0.to[[j.for.to]],n.to,the)$like,
                           gr = function(the) unlist(der.l(x0.to[[j.for.to]],y0.to[[j.for.to]],n.to,the)),
                           method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
    }else{
      hyper.to.ucb = hyper.to.ucb
    }
    
    like.re.to[[j.for.to]][[i.to+1]] = likeli.to(x0.to[[j.for.to]],y0.to[[j.for.to]],n.to,hyper.to.ucb)
    hyper.to[[j.for.to]][[i.to+1]] = like.re.to[[j.for.to]][[i.to+1]]$the0
    print(i.to)
  }
  
  togp.bo[[j.for.to]] = Map(function(a) true.model(a),split(x0.to[[j.for.to]],row(x0.to[[j.for.to]])))
  h.to[[j.for.to]] = apply(x0.to[[j.for.to]],1,h)
  
  mse.x.to[[j.for.to]] = apply(x0.to[[j.for.to]],1,function(x) mean((x-x.star)^2))
  mae.y.to[[j.for.to]] = unlist(lapply(togp.bo[[j.for.to]],function(a) mean(abs((a-c(t.star))/c(t.star)))))
  
  regret.to[[j.for.to]] = h(x.star)-unlist(h.to[[j.for.to]])
  ins.regret.to[[j.for.to]] = h(x.star)-cummax(unlist(h.to[[j.for.to]]))
  cum.regret.to[[j.for.to]] = cumsum(ins.regret.to[[j.for.to]])
  
  plot(rep(h.star,(n.to-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(unlist(h.to[[j.for.to]])[n],h.star))
  lines(cummax(unlist(h.to[[j.for.to]]))[n:n.to],type="b",lwd=3,lty=2,pch=2,col=2)
  
  plot(log(ins.regret.to[[j.for.to]]+1e-10)[n:n.to],type="b",lwd=3,lty=1,pch=1,col=1)
  
  print(j.for.to)
}

fto.rs.list = list(like.re.to=like.re.to, hyper.to=hyper.to, fhat=fhat,
                    x0.to=x0.to, y0.to=y0.to, togp.bo=togp.bo, h.to=h.to, 
                    mse.x.to=mse.x.to, mae.y.to=mae.y.to, regret.to=regret.to,
                    ins.regret.to=ins.regret.to, cum.regret.to=cum.regret.to)
save(fto.rs.list, file="s3.fto.rs.list.RData")


